require( "quest/m3_maze3/convout.lua" );
require( "quest/m3_maze_shared/m3_maze_shared.lua" );
combine_speech_tables();

local max_memo_pieces = 10;

local memo_piece_reach_pos = 
{ 
	{ row = 1, col = 1 }, -- piece 1
	{ row = 2, col = 3 }, -- piece 2
	{ row = 2, col = 6 }, -- piece 3
	{ row = 3, col = 9 }, -- piece 4
	{ row = 2, col = 11 }, -- piece 5
	{ row = 5, col = 8 }, -- piece 6
	{ row = 6, col = 2 }, -- piece 7
	{ row = 5, col = 3 }, -- piece 8
	{ row = 6, col = 7 }, -- piece 9
	{ row = 6 , col = 12 } -- piece 10
}

local memo_piece_image = 
{ 
	"maze_memo1", -- piece 1
	"maze_memo2", -- piece 2
	"maze_memo1", -- piece 3
	"maze_memo2", -- piece 4
	"maze_memo1", -- piece 5
	"maze_memo2", -- piece 6
	"maze_memo1", -- piece 7
	"maze_memo2", -- piece 8
	"maze_memo1", -- piece 9
	"maze_memo2" -- piece 10
}	

function flo_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get( "talked_to_secretary_1" ) < 1 then
		run_super_conversation(flo, "qiup_maze3_flo_a");
	else
		local memo_pieces_found = game:Get("memo_pieces_found");
		if memo_pieces_found < max_memo_pieces then
			run_super_conversation(flo, "qiup_maze3_flo_b");
		elseif memo_pieces_found == max_memo_pieces and game:Get( "got_permit_stamped") < 1 then
			if game:Get( "got_copied_memo" ) < 1 then
				run_super_conversation(flo, "qiup_maze3_flo_c");
			else
				run_super_conversation(flo, "quip_maze3_flo_d");
			end
		else
			run_super_conversation(flo, "quip_bigcorp_music");
		end
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:FaceNow(DIR.S);
		actor:SetWalkSpeed(flo_speed);
		actor:JumpToNamedPoint("flo");
		actor:SetScale(0.6);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		--actor:SetDepthValue( 2000 );
		
		maze_position = { row = 1, col = 10 };
		--maze_position = { row = 1, col = 5 };
		
		actor:StartProc(goto_new_maze_position);
		
		scene:SetCameraFollowActor(actor);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(flo_conv);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function goto_exit(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("flo");
	wait_walkto();
	
	goto_scene(flo, "m3_landing50");
end

elevator_spec = 
{
	name = "ELEVATOR";
	halo = "elevator";
	goto_fn = goto_exit;
	cursor = "cursor_arrow_n";
}

copier_spec = 
{
	name = "COPIER";
	halo = "copier";
	
	command = function(actor)
		actor.closeEnoughPos = { row = 4, col = 9 };
	end;
	
	on_use_inv = function(item, flo, copier)
		if ( maze_position.row == copier.closeEnoughPos.row and maze_position.col == copier.closeEnoughPos.col ) then
			if ( item == "memo_pieces" ) then		
				if ( game:Get( "got_copied_memo" ) ~= 1 ) then
					--BAG_INV:RemoveInventory( inv_desc_memo_pieces );
					flo:StartProc(got_copy);	
				else
					flo:StartProc(already_copied_that);		
				end
			elseif item == "memocollection" then
				flo:StartProc(not_ready_copy);
			else
				flo:StartProc(cant_copy_that);	
			end
		else
			convproc("FLO", "conv_maze3_get_closer_memo");
		end
	end;
	
	on_arrive = function(flo, copier)
		if ( maze_position.row == copier.closeEnoughPos.row and maze_position.col == copier.closeEnoughPos.col ) then
			flo:StartProc(its_a_copier);
		else
			convproc("FLO", "conv_maze3_get_closer_memo");
		end
	end;
}

secretary_anim_table = 
{
	"anim/tanya/stand",
	"anim/tanya/talk",
	"anim/tanya/stamp",
};

function talk_to_secretary(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("secretary_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	if ( game:Get( "talked_to_secretary_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_maze3_stamp");
		game:Set( "talked_to_secretary_1", 1 );
		add_quest("make_copy");
		wait_subscene();
	elseif BAG_INV:CheckInventory("memo") then
		run_super_conversation(flo, "conv_give_memo");
	else
		run_super_conversation(flo, "conv_collect_pieces");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_memo_piece_spec(index)
	return
	{
		name = "MEMO_PIECE_" .. tostring(index);
		halo = "memo_piece";
		gfx = { image = memo_piece_image[index] };
		
		command = function(actor)		
			if ( game:Get( "got_permit_signed" ) == 1 and game:Get("got_memo_piece_" .. index) ~= 1 ) then			
				actor:JumpToNamedPoint( "memo_piece_" .. tostring(index) );
			else
				actor:SetAlpha( 0 );
			end
			--actor:SetDepthValue( 2000 );
			actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		end;
		
		on_click = function(flo, memo_piece)
			if game:Get( "talked_to_secretary_1" ) == 1 then
				if ( maze_position.row == memo_piece_reach_pos[index].row and maze_position.col == memo_piece_reach_pos[index].col ) then
					game:Set("got_memo_piece_" .. index, 1);
					local memo_pieces_found = game:Get("memo_pieces_found");
					memo_pieces_found = memo_pieces_found + 1;
					game:Set("memo_pieces_found", memo_pieces_found);
					
					local position = memo_piece:GetScreenPosition();
					position.x = position.x + memo_piece:GetImageSize().x / 2;
					position.y = position.y - memo_piece:GetImageSize().y / 2;
					local key = inv_desc_memocollection.key;
					
					game:SetString("inventory_fly_back_item", key);
					game:Set("inventory_fly_back_loc_X", position.x);
					game:Set("inventory_fly_back_loc_Y", position.y);
					
					memo_piece:Expire();
					scene.FLO:StartProc(wait_for_memo_piece_fly)
					return RESPONSE.IGNORE;
				else
					flo:StartProc(get_closer_to_memo_piece)
				end
			else
				convproc("FLO", "quip_maze3_scrap");
			end
		end;
	};
end

function wait_for_memo_piece_fly(flo)
	flo:SetMode(MODE.CUTSCENE);
	local memo_pieces_found = game:Get("memo_pieces_found");
	local key = game:GetString("inventory_fly_back_item");
	
	if memo_pieces_found == 1 then
		addInventory(inv_desc_memocollection);
		BAG_INV:SetInventoryOvertextColor("memocollection", Color8888(0,0,0,255));
		BAG_INV:SetInventoryOvertextFlags("memocollection", kHAlignRight + kVAlignCenter);
	else
		-- scroll so the item's SLOT is visible
		BAG_INV:PositionInventoryForVisibility(key);
		
		-- go straight there (don't wait)
		BAG_INV:JumpInventoryToTarget(key);
		
		if memo_pieces_found == 1 then 
			-- disable the item iteself
			BAG_INV:ShowInventory(key, false);
		end
		
		-- do the work
		sfx:PlaySFX("audio/sfx/flower_found");
		
		scene:Spawn(inventory_flyback_spec);
		coroutine.yield(RESUME.ON_SIGNAL);
		
		-- re-enable the item
		BAG_INV:ShowInventory(key, true);
		
		--delay(30); -- make it snappy!
		scene.INVENTORY_FLYBACK:Expire();
		delay(2);
	end
	
	if memo_pieces_found == max_memo_pieces then
		BAG_INV:RemoveInventory("memocollection");
		addInventory(inv_desc_memo_pieces);
		
		spawn_activity_complete_text("activity_complete_text_memo", "audio/sfx/complete_display.ogg");
		coroutine.yield(RESUME.ON_SIGNAL);
		
	else
		local memoText = tostring(memo_pieces_found) .. " / "  .. tostring(max_memo_pieces);
		BAG_INV:SetInventoryOvertextFlags("memocollection", kHAlignCenter + kVAlignTop);
		BAG_INV:SetInventoryOvertext("memocollection", memoText);
	end
	
	-- clean up
	game:SetString("inventory_fly_back_item", "");
	game:Set("inventory_fly_back_loc_X", "");
	game:Set("inventory_fly_back_loc_Y", "");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_memo_to_secretary(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	run_super_conversation(flo, "conv_permit_stamp");
	scene.PERMIT:Expire();
	addInventory(inv_desc_permit_stamped);		
	BAG_INV:RemoveInventory("memo_pieces");
	BAG_INV:RemoveInventory("memo");
	BAG_INV:RemoveInventory("keycard");
	BAG_INV:RemoveInventory("bluekey");
	game:Set( "got_permit_stamped", 1 );
	complete_quest("got_permit");
	wait_subscene();
	goto_scene(flo, "m3_big");
end

secretary_spec = 
{
	name = "SECRETARY";
	halo = "quest/objects/secretary";
	anim = secretary_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, secretary_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);		
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(secretary_speed);
		actor:SetScale(0.7);
		--actor:SetDepthValue( 110 );
		
		if ( game:Get("got_permit_signed") == 1 ) then			
			actor:JumpToNamedPoint("secretary");
		else
			actor:SetAlpha( 0 );
		end
		actor.closeEnoughPos = { row = 1, col = 5 };
	end;
	
	on_arrive = function(flo, secretary)
		if ( maze_position.row == secretary.closeEnoughPos.row and maze_position.col == secretary.closeEnoughPos.col ) then
			flo:StartProc(talk_to_secretary);
		else
			flo:StartProc(get_closer);		
		end
	end;
	
	on_use_inv = function(item, flo, secretary)
		if ( maze_position.row == secretary.closeEnoughPos.row and maze_position.col == secretary.closeEnoughPos.col ) then	
			if (  item == "memo" ) then
				flo:StartProc(give_memo_to_secretary);
			elseif ( item == "memo_pieces" ) then
				flo:StartProc(need_copy);
			elseif item == "permit_stamped" then
				flo:StartProc(already_got_stamp);
			else
				flo:StartProc(dont_need);		
			end		
		else
			flo:StartProc(get_closer);		
		end
	end;
};

function got_copy(flo)
	flo:SetMode(MODE.CUTSCENE);
	sfx:PlaySFX("audio/sfx/big_copier.ogg");
	BAG_INV:RemoveInventory( "memo_pieces" );
	delay(60);
	addInventory( inv_desc_memo );
	game:Set( "got_copied_memo", 1 );
	
	spawn_activity_complete_text("activity_complete_text_copy", "audio/sfx/complete_display.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	run_super_conversation(flo, "conv_got_copy");
	complete_quest("make_copy");
	wait_subscene();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_closer(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_maze3_get_closer_secretary");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function dont_need(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_maze3_dont_need");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_closer_to_memo_piece(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_maze3_get_closer_memo");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function its_a_copier(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_copier");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function cant_copy_that(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_no_copy");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function not_ready_copy(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_not_ready_copy");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function already_copied_that(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_already_copied");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function need_copy(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_need_copy");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function already_got_stamp(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_already_got_stamp");
	flo:SetMode(MODE.FOLLOWCLICKS);
end


function talk_to_cubicle1(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle1_walkto");
	wait_walkto();
	
	flo:FaceActor(cubicle1);
	
	if ( game:Get( "talked_to_secretary_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_maze3_not_secretary");
	else
		scene.BARB1:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.BARB1:PlayAnim("Idle");
		wait_anim(scene.BARB1);
		
		scene.BARB1:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.BARB1:PlayAnim("DoStandE");
		
		run_super_conversation(flo, "conv_maze3_barb_a");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle1_spec = 
{
	name = "BARB1";
	halo = "quest/objects/cubicle1";
	gfx = { anim = "anim/barb/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle1_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle1");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle1_speed);
		actor:FaceNow(DIR.E);
		actor.closeEnoughPos = { row = 3, col = 10 };
	end;
	
	on_arrive = function(flo, cubicle1)
		if ( maze_position.row == cubicle1.closeEnoughPos.row and maze_position.col == cubicle1.closeEnoughPos.col ) then	
			flo:StartProc(talk_to_cubicle1);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

function talk_to_cubicle2(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle2_walkto");
	wait_walkto();
	
	flo:Face(DIR.SW);
	delay(15);
	
	if ( game:Get( "talked_to_secretary_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_maze3_not_secretary");
	else
		scene.BARB2:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.BARB2:PlayAnim("Idle");
		wait_anim(scene.BARB2);
		
		scene.BARB2:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.BARB2:PlayAnim("DoStandE");
		
		run_super_conversation(flo, "conv_maze3_barb_b");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle2_spec = 
{
	name = "BARB2";
	halo = "quest/objects/cubicle1";
	gfx = { anim = "anim/barb/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle2_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle2");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle2_speed);
		actor:FaceNow(DIR.E);
		actor.closeEnoughPos = { row = 3, col = 4 };
	end;
	
	on_arrive = function(flo, cubicle2)
		if ( maze_position.row == cubicle2.closeEnoughPos.row and maze_position.col == cubicle2.closeEnoughPos.col ) then	
			flo:StartProc(talk_to_cubicle2);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

cubicle3_anim_table = 
{
	"anim/cubicle3/stand",
	"anim/cubicle3/talkw",
};

function talk_to_cubicle3(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle3_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	if ( game:Get( "talked_to_secretary_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_maze3_not_secretary");
	else	
		scene.SEYMOUR:LastingEmotion();
		scene.SEYMOUR:SetEmotion("look");
		
		scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.SEYMOUR:PlayAnim("ToTalkW");
		wait_anim(scene.SEYMOUR);
		
		scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.SEYMOUR:PlayAnim("DoStandW_look");
		
		run_super_conversation(flo, "conv_maze3_seymour");
		
		scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.SEYMOUR:PlayAnim("FromTalkW");
		wait_anim(scene.SEYMOUR);
		
		scene.SEYMOUR:QuickEmotion();
		scene.SEYMOUR:ClearEmotion();
		
		scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.SEYMOUR:PlayAnim("DoStandW");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle3_spec = 
{
	name = "SEYMOUR";
	halo = "quest/objects/cubicle3";
	gfx = { anim = "anim/seymour/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle3_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle3");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle3_speed);
		actor:FaceNow(DIR.W);
		actor.closeEnoughPos = { row = 3, col = 5 };
	end;
	
	on_arrive = function(flo, cubicle3)
		if ( maze_position.row == cubicle3.closeEnoughPos.row and maze_position.col == cubicle3.closeEnoughPos.col ) then	
			flo:StartProc(talk_to_cubicle3);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

function talk_to_cubicle4(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:WalkTo("cubicle4_walkto");
	wait_walkto();
	
	flo:Face(DIR.W);
	
	if ( game:Get( "talked_to_secretary_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_maze3_not_secretary");
	else
		scene.NORBERT:LastingEmotion();
		scene.NORBERT:SetEmotion("talk");
		
		scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.NORBERT:PlayAnim("ToTalkE");
		wait_anim(scene.NORBERT);
		
		scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.NORBERT:PlayAnim("DoStandE_talk");
		
		run_super_conversation(flo, "conv_maze3_norbert");
		
		scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.NORBERT:PlayAnim("FromTalkE");
		wait_anim(scene.NORBERT);
		
		scene.NORBERT:QuickEmotion();
		scene.NORBERT:ClearEmotion();
		
		scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		scene.NORBERT:PlayAnim("DoStandE");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle4_spec = 
{
	name = "NORBERT";
	halo = "quest/objects/cubicle4";
	gfx = { anim = "anim/norbert/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle4_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle4");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle4_speed);
		actor:FaceNow(DIR.E);
		actor:SetScale(0.7);
		actor.closeEnoughPos = { row = 5, col = 3 };
	end;
	
	on_arrive = function(flo, cubicle4)
		if ( maze_position.row == cubicle4.closeEnoughPos.row and maze_position.col == cubicle4.closeEnoughPos.col ) then	
			flo:StartProc(talk_to_cubicle4);
		else
			convproc("FLO", "conv_maze1_get_closer");
		end
	end;
};

debugPrint_spec =
{
	name = "debugPrint";
	
	command = function(actor)
		actor:SetDepthValue( 3000 );
		
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = -15,
			w = 90,
			h = 25,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
}

function spawn_memo_pieces()
	for i = 1, max_memo_pieces do
		scene:Spawn( get_memo_piece_spec( i ) );
	end
end

permit_spec = 
{
	name = "PERMIT";
	gfx = { image = "maze3_permit" };
	
	command = function(actor)
		actor:SetDepthValue(246);
	end;
}

maze_fax_spec = 
{
	name = "MAZE_FAX";
	halo = "maze_fax";
	
	command = function(actor)
		actor:SetDepthValue(5);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				sfx:PlaySFX("audio/sfx/big_fax");
				delay(20);
				run_super_conversation(flo, "quip_maze_fax");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
		--scene:SetFadeSpeed(1.0);
		--wait_fade();
		
		spawn_load_bar("MAZE_LOAD", "text_maze_load", 11);
		
		coroutine.yield(RESUME.ON_DELAY);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory( inv_desc_keycard );
			--BAG_INV:AddInventory( inv_desc_bluekey );
			--BAG_INV:AddInventory( inv_desc_permit_signed );
			--BAG_INV:AddInventory( inv_desc_memo );
			--game:Set( "got_permit_signed", 1);
			--game:Set( "talked_to_secretary_1", 1);
		end
		--[[
		for i = 1,10 do
			update_load_bar("MAZE_LOAD", i);
			delay(10);
		end
		--]]
		
		scene:LoadAtlas("quest/m3_maze_shared/pieces1"); -- load pieces
		scene:LoadAtlas("quest/m3_maze_shared/arrows"); -- load arrows
		scene:LoadAtlas("pieces1");
		scene:LoadAtlas("pieces2");
		scene:LoadAtlas("pieces3");
		scene:LoadAtlas("pieces4");
		
		update_load_bar("MAZE_LOAD", 1);
		
		spawn_memo_pieces();	
		
		spawn_simple_hotspot("maze_plant", 5);
		spawn_simple_hotspot("maze_cooler", 5);
		spawn_simple_hotspot("maze_file", 5);
		spawn_simple_hotspot("maze_soda", 5);
		spawn_simple_hotspot("maze_donuts", 5, 3);
		spawn_simple_hotspot("maze_recycle", 5);
		spawn_simple_hotspot("maze_poster1", 5);
		spawn_simple_hotspot("maze_poster2", 5);
		spawn_simple_hotspot("maze_poster4", 5);
		spawn_simple_hotspot("maze_calendar", 5);
		spawn_simple_hotspot("maze2_plantworker", 5);
		spawn_simple_hotspot("maze3_bigdoor", 5);
		spawn_simple_hotspot("maze_whiteboard", 5);
		
		update_load_bar("MAZE_LOAD", 2);
		
		spawn_nav_arrow(elevator_spec);
		
		spawn_bg_actor("maze3_exit", 100 );
		spawn_bg_actor("maze3_big_door", 100 );
		spawn_bg_actor("maze3_sec_desk", 245 );		
		spawn_bg_actor( "maze3_row1a", 435 );
		spawn_bg_actor( "maze3_row1b", 436 );
		spawn_bg_actor( "maze3_row1c", 437 );
		spawn_bg_actor( "maze3_row1d", 438 );
		spawn_bg_actor( "maze3_row1e", 439 );
		spawn_bg_actor( "maze3_row1f", 440 );
		spawn_bg_actor( "maze3_row1g", 440 );
		spawn_bg_actor( "maze3_row1h", 320 );
		spawn_bg_actor( "maze3_row1i", 320 );
		spawn_bg_actor( "maze3_row1j", 320 );
		spawn_bg_actor( "maze3_row1k", 319 );
		
		update_load_bar("MAZE_LOAD", 3);
		
		--spawn_bg_actor( "character_norbert", 490 );
		spawn_bg_actor( "maze3_row2a", 709 );
		spawn_bg_actor( "maze3_row2b", 710 );
		spawn_bg_actor( "maze3_row2c", 711 );
		spawn_bg_actor( "maze3_row2d", 712 );
		spawn_bg_actor( "maze3_row2e", 713 );
		spawn_bg_actor( "maze3_row2f", 714 );
		spawn_bg_actor( "maze3_row2g", 715 );
		spawn_bg_actor( "maze3_row2h", 700 );
		spawn_bg_actor( "maze3_row2i", 699 );
		spawn_bg_actor( "maze3_row2j", 700 );
		spawn_bg_actor( "maze3_row2k", 700 );
		spawn_bg_actor( "maze3_row2l", 500 );
		spawn_bg_actor( "maze3_row2m", 700 );
		spawn_bg_actor( "maze3_row2n", 699 );
		
		update_load_bar("MAZE_LOAD", 4);
		
		--spawn_bg_actor( "character_rosie", 812 );
		spawn_bg_actor( "maze3_row3a", 990 );
		spawn_bg_actor( "maze3_row3b", 989 );
		spawn_bg_actor( "maze3_row3c", 988 );
		spawn_bg_actor( "maze3_row3d", 987 );
		spawn_bg_actor( "maze3_row3e", 986 );
		spawn_bg_actor( "maze3_row3f", 985 );
		spawn_bg_actor( "maze3_row3g", 984 );
		spawn_bg_actor( "maze3_row3h", 850 );
		spawn_bg_actor( "maze3_row3i", 849 );
		spawn_bg_actor( "maze3_row3j", 850 );
		spawn_bg_actor( "maze3_row3k", 850 );
		spawn_bg_actor( "maze3_row3l", 850 );
		spawn_bg_actor( "maze3_row3m", 849 );
		
		update_load_bar("MAZE_LOAD", 5);
		
		--spawn_bg_actor( "character_loretta", 1025 );
		spawn_bg_actor( "maze3_row4a", 1135 );
		spawn_bg_actor( "maze3_row4b", 1136 );
		spawn_bg_actor( "maze3_row4c", 1137 );
		spawn_bg_actor( "maze3_row4d", 1138 );
		spawn_bg_actor( "maze3_row4e", 1139 );
		spawn_bg_actor( "maze3_row4f", 1140 );
		spawn_bg_actor( "maze3_row4g", 1125 );
		spawn_bg_actor( "maze3_row4h", 1125 );
		spawn_bg_actor( "maze3_row4i", 1125 );
		spawn_bg_actor( "maze3_row4j", 1125 );
		spawn_bg_actor( "maze3_row4k", 1124 );
		spawn_bg_actor( "chair_mask_3", 1140);
		
		update_load_bar("MAZE_LOAD", 6);
		
		--spawn_bg_actor( "character_joe", 1275 );
		--spawn_bg_actor( "character_chloe", 1280 );
		spawn_bg_actor( "maze3_row5a", 1425 );
		spawn_bg_actor( "maze3_row5b", 1424 );
		spawn_bg_actor( "maze3_row5c", 1423 );
		spawn_bg_actor( "maze3_row5d", 1422 );
		spawn_bg_actor( "maze3_row5e", 1421 );
		spawn_bg_actor( "maze3_row5f", 1420 );
		spawn_bg_actor( "maze3_row5g", 1405 );
		spawn_bg_actor( "maze3_row5h", 1405 );
		spawn_bg_actor( "maze3_row5i", 1405 );
		spawn_bg_actor( "maze3_row5j", 1405 );
		spawn_bg_actor( "maze3_row5k", 1405 );
		spawn_bg_actor( "maze3_row5l", 1405 );
		
		update_load_bar("MAZE_LOAD", 7);
		
		spawn_bg_actor( "maze3_row5m", 1404 );
		spawn_bg_actor( "maze3_row6a", 1805 );
		spawn_bg_actor( "maze3_row6b", 1804 );
		spawn_bg_actor( "maze3_row6c", 1803 );
		spawn_bg_actor( "maze3_row6d", 1802 );
		spawn_bg_actor( "maze3_row6e", 1801 );
		spawn_bg_actor( "maze3_row6f", 1800 );
		spawn_bg_actor( "maze3_row6g", 1680 );
		spawn_bg_actor( "maze3_row6h", 1680 );
		
		update_load_bar("MAZE_LOAD", 8);
		
		spawn_bg_actor( "maze3_furniture01", 295 );
		spawn_bg_actor( "maze3_furniture02", 100 );
		spawn_bg_actor( "maze3_furniture03", 350 );
		spawn_bg_actor( "maze3_furniture04", 100 );
		spawn_bg_actor( "maze3_furniture05", 240 );
		spawn_bg_actor( "maze3_furniture06", 495 );
		spawn_bg_actor( "maze3_furniture07", 485 );
		spawn_bg_actor( "maze3_furniture08", 475 );
		spawn_bg_actor( "maze3_furniture09", 710 );
		spawn_bg_actor( "maze3_furniture10", 765 );
		spawn_bg_actor( "maze3_furniture11", 765 );
		spawn_bg_actor( "maze3_furniture12", 720 );
		spawn_bg_actor( "maze3_furniture13", 1040 );
		spawn_bg_actor( "maze3_furniture14", 1140 );
		spawn_bg_actor( "maze3_furniture15", 1140 );
		spawn_bg_actor( "maze3_furniture16", 1104 );
		spawn_bg_actor( "maze3_furniture17", 1065 );
		spawn_bg_actor( "maze3_furniture18", 1150 );
		spawn_bg_actor( "maze3_furniture19", 1190 );
		spawn_bg_actor( "maze3_furniture20", 1305 );
		spawn_bg_actor( "maze3_furniture21", 1305 );
		spawn_bg_actor( "maze3_furniture22", 1580 );
		spawn_bg_actor( "maze3_furniture23", 1590 );
		spawn_bg_actor( "maze3_furniture24", 1745 );
		spawn_bg_actor( "maze3_furniture25", 1745 );
		
		update_load_bar("MAZE_LOAD", 9);
		
		scene:Spawn(cubicle1_spec);
		scene:Spawn(cubicle2_spec);
		scene:Spawn(cubicle3_spec);
		scene:Spawn(cubicle4_spec);
		
		update_load_bar("MAZE_LOAD", 10);
		
		scene:Spawn(debugPrint_spec);
		scene:Spawn(secretary_spec);
		scene:Spawn(copier_spec);
		scene:Spawn(maze_fax_spec);
		
		scene:Spawn(flo_spec);
		
		update_load_bar("MAZE_LOAD", 11);
		
		kill_load_bar("MAZE_LOAD");
		
		fade_scene_up();
	end;
};

scene_spec =
{
	atlas = 
	{
	--[[
		"quest/m3_maze_shared/arrows", -- load arrows
		"quest/m3_maze_shared/pieces1", -- load pieces
		"pieces1",
		"pieces2",
		"pieces3",
		"pieces4",
	--]]
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		--[[
		{"maze3_exit", 100 },
		{"maze3_big_door", 100 },
		{"maze3_sec_desk", 245 },		
		{ "maze3_row1a", 435 },
		{ "maze3_row1b", 436 },
		{ "maze3_row1c", 437 },
		{ "maze3_row1d", 438 },
		{ "maze3_row1e", 439 },
		{ "maze3_row1f", 440 },
		{ "maze3_row1g", 440 },
		{ "maze3_row1h", 320 },
		{ "maze3_row1i", 320 },
		{ "maze3_row1j", 320 },
		{ "maze3_row1k", 319 },
		--{ "character_norbert", 490 },
		{ "maze3_row2a", 709 },
		{ "maze3_row2b", 710 },
		{ "maze3_row2c", 711 },
		{ "maze3_row2d", 712 },
		{ "maze3_row2e", 713 },
		{ "maze3_row2f", 714 },
		{ "maze3_row2g", 715 },
		{ "maze3_row2h", 700 },
		{ "maze3_row2i", 699 },
		{ "maze3_row2j", 700 },
		{ "maze3_row2k", 700 },
		{ "maze3_row2l", 500 },
		{ "maze3_row2m", 700 },
		{ "maze3_row2n", 699 },
		--{ "character_rosie", 812 },
		{ "maze3_row3a", 990 },
		{ "maze3_row3b", 989 },
		{ "maze3_row3c", 988 },
		{ "maze3_row3d", 987 },
		{ "maze3_row3e", 986 },
		{ "maze3_row3f", 985 },
		{ "maze3_row3g", 984 },
		{ "maze3_row3h", 850 },
		{ "maze3_row3i", 849 },
		{ "maze3_row3j", 850 },
		{ "maze3_row3k", 850 },
		{ "maze3_row3l", 850 },
		{ "maze3_row3m", 849 },
		--{ "character_loretta", 1025 },
		{ "maze3_row4a", 1135 },
		{ "maze3_row4b", 1136 },
		{ "maze3_row4c", 1137 },
		{ "maze3_row4d", 1138 },
		{ "maze3_row4e", 1139 },
		{ "maze3_row4f", 1140 },
		{ "maze3_row4g", 1125 },
		{ "maze3_row4h", 1125 },
		{ "maze3_row4i", 1125 },
		{ "maze3_row4j", 1125 },
		{ "maze3_row4k", 1124 },
		{ "chair_mask_3", 1140},
		--{ "character_joe", 1275 },
		--{ "character_chloe", 1280 },
		{ "maze3_row5a", 1425 },
		{ "maze3_row5b", 1424 },
		{ "maze3_row5c", 1423 },
		{ "maze3_row5d", 1422 },
		{ "maze3_row5e", 1421 },
		{ "maze3_row5f", 1420 },
		{ "maze3_row5g", 1405 },
		{ "maze3_row5h", 1405 },
		{ "maze3_row5i", 1405 },
		{ "maze3_row5j", 1405 },
		{ "maze3_row5k", 1405 },
		{ "maze3_row5l", 1405 },
		{ "maze3_row5m", 1404 },
		{ "maze3_row6a", 1805 },
		{ "maze3_row6b", 1804 },
		{ "maze3_row6c", 1803 },
		{ "maze3_row6d", 1802 },
		{ "maze3_row6e", 1801 },
		{ "maze3_row6f", 1800 },
		{ "maze3_row6g", 1680 },
		{ "maze3_row6h", 1680 },
		
		{ "maze3_furniture01", 295 },
		{ "maze3_furniture02", 100 },
		{ "maze3_furniture03", 350 },
		{ "maze3_furniture04", 100 },
		{ "maze3_furniture05", 240 },
		{ "maze3_furniture06", 495 },
		{ "maze3_furniture07", 485 },
		{ "maze3_furniture08", 475 },
		{ "maze3_furniture09", 710 },
		{ "maze3_furniture10", 765 },
		{ "maze3_furniture11", 765 },
		{ "maze3_furniture12", 720 },
		{ "maze3_furniture13", 1040 },
		{ "maze3_furniture14", 1140 },
		{ "maze3_furniture15", 1140 },
		{ "maze3_furniture16", 1104 },
		{ "maze3_furniture17", 1065 },
		{ "maze3_furniture18", 1150 },
		{ "maze3_furniture19", 1190 },
		{ "maze3_furniture20", 1305 },
		{ "maze3_furniture21", 1305 },
		{ "maze3_furniture22", 1580 },
		{ "maze3_furniture23", 1590 },
		{ "maze3_furniture24", 1745 },
		{ "maze3_furniture25", 1745 },

		--]]
		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
	};
};
